/*
 *  Java OTR library
 *  Copyright (C) 2008-2009  Ian Goldberg, Muhaimeen Ashraf, Andrew Chung,
 *                           Can Tang
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of version 2.1 of the GNU Lesser General
 *  Public License as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package ca.uwaterloo.crysp.otr.crypt.rim;

import net.rim.device.api.crypto.AESKey;

/**
 * Wrapper class for the AES key provided by RIM
 * 
 */
public class RIMAESKey extends ca.uwaterloo.crysp.otr.crypt.AESKey {
    AESKey secretKey;

    /**
     * Constructs the wrapping instance of the given AES key using the RIM
     * provider.
     * 
     * @param secretKey
     *            the AES key.
     */
    public RIMAESKey(AESKey secretKey) {
        this.secretKey = secretKey;
    }

    /**
     * Constructs an AES key from a byte-array.
     * 
     * @param encodedKey
     *            The encoded key.
     */
    public RIMAESKey(byte[] encodedKey) {
        secretKey = new AESKey(encodedKey);
    }

    /**
     * Returns the RIM instance of the secret key.
     * 
     * @return the RIM instance of the secret key.
     */
    public AESKey getSecretKey() {
        return secretKey;
    }

    public String toString() {
        return secretKey.toString();
    }

    public byte[] getEncoded() {
        try {
            return secretKey.getData();
        } catch (Exception e) {
        }
        return null;
    }

}
